#include <pwm.h>
#include <p30fxxxx.h>

/* PWM1-3 are defined in following devices */
#if defined(__dsPIC30F2010__) || defined(__dsPIC30F3010__) || defined(__dsPIC30F4012__) || \
    defined(__dsPIC30F3011__) || defined(__dsPIC30F4011__) || defined(__dsPIC30F6010__) || defined(__dsPIC30F5015__)

/*********************************************************************
* Function Name     : OpenMCPWM
* Description       : This function configures PWM module for the 
*                     following parameters:
*                     period, sptime, PWM Mode, Clock Prescale,
*                     Output Postscale, high res mode, I/O pair mode, 
*                     I/O pair mode,I/O pair enable, Special event 
*                     postscale, Special event direction, override 
*                     synchronization.
* Parameters        : unsigned int period
*                     unsigned int sptime
*                     unsigned int config1
*                     unsigned int config2, 
*                     unsigned int config3
* Return Value      : None 
**********************************************************************/

void OpenMCPWM(unsigned int period, unsigned int sptime, unsigned int 
               config1, unsigned int config2, unsigned int config3)
{
    PTPER   = period;
    SEVTCMP = sptime;
    PWMCON1 = config2;
    PWMCON2 = config3;
    PTCON   = config1;
}

#endif
